# Redmine LINE テーマ実装ガイド：新規チケット画面の対応

## 概要

新規チケット作成画面のHTMLソースを分析した結果、LINEデザイン言語に基づいたスタイリングは完全に実現可能です。ここでは、この画面特有の実装方法と注意点を解説します。

## HTML構造の特徴と対応方法

### 1. `nosidebar`クラスとレイアウト

新規チケット作成画面は`nosidebar`クラスが付与されており、サイドバーがありません：

```html
<div id="main" class="nosidebar">
```

**対応方法**：
```css
/* サイドバーなしのメインエリア */
#main.nosidebar #content {
  max-width: 900px;
  margin: 0 auto;
}
```

このスタイルにより、コンテンツを中央に配置し、適切な最大幅を設定します。

### 2. フォームの構造

```html
<form class="new_issue" id="issue-form" enctype="multipart/form-data">
  <div class="box tabular">
    <!-- フォームフィールド -->
  </div>
  
  <!-- 添付ファイル -->
  <p id="attachments_form">...</p>
  
  <!-- ウォッチャー -->
  <div id="watchers_form_container">...</div>
  
  <!-- 送信ボタン -->
  <input type="submit" name="commit" value="作成">
  <input type="submit" name="continue" value="連続作成">
</form>
```

**対応方法**：

各セクションを独立したカード型UIとして扱い、それぞれに適切な間隔、角丸、影を適用します：

```css
/* フォーム全体のスタイリング */
.box.tabular,
#attachments_form,
#watchers_form_container {
  background-color: var(--line-white);
  border-radius: var(--border-radius-medium);
  padding: 20px;
  box-shadow: var(--shadow-small);
  margin-bottom: 20px;
}
```

### 3. フォームフィールドのレイアウト

フォームフィールドは`splitcontent`、`splitcontentleft`、`splitcontentright`のクラスでレイアウトされています：

```html
<div class="splitcontent">
  <div class="splitcontentleft">
    <!-- 左側フィールド -->
  </div>
  <div class="splitcontentright">
    <!-- 右側フィールド -->
  </div>
</div>
```

**対応方法**：

フレックスボックスを使用してレスポンシブなレイアウトを実現します：

```css
.splitcontent {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  margin-top: 20px;
}

.splitcontentleft, .splitcontentright {
  flex: 1;
  min-width: 300px;
}

@media screen and (max-width: 767px) {
  .splitcontent {
    flex-direction: column;
  }
  
  .splitcontentleft, .splitcontentright {
    width: 100%;
  }
}
```

### 4. テキストエディタのツールバー

Redmineはテキストエディタに独自のツールバーを使用しています：

```html
<div class="jstElements">
  <button type="button" title="太字">B</button>
  <!-- その他のボタン -->
</div>
```

**対応方法**：

ツールバーをLINEデザイン言語に合わせてスタイリングします：

```css
.jstElements {
  background-color: var(--line-panel-bg);
  border-radius: var(--border-radius-small);
  padding: 5px;
  margin-bottom: 5px;
}

.jstElements button {
  background-color: var(--line-white);
  border: 1px solid var(--line-mid-gray);
  border-radius: var(--border-radius-small);
  margin: 2px;
  padding: 4px 8px;
  cursor: pointer;
  transition: all 0.2s;
}

.jstElements button:hover {
  background-color: rgba(6, 199, 85, 0.1);
  border-color: var(--line-primary);
}
```

### 5. 添付ファイルエリア

```html
<p id="attachments_form">
  <span class="attachments_form">
    <span class="add_attachment">
      <!-- ファイル選択UI -->
    </span>
  </span>
</p>
```

**対応方法**：

ドラッグ＆ドロップエリアをより視覚的にわかりやすくスタイリングします：

```css
.attachments_form .add_attachment {
  display: block;
  margin-top: 10px;
  padding: 15px;
  border: 2px dashed var(--line-mid-gray);
  border-radius: var(--border-radius-small);
  background-color: var(--line-panel-bg);
  text-align: center;
  transition: all 0.2s;
}

.attachments_form .add_attachment:hover {
  border-color: var(--line-primary);
  background-color: rgba(6, 199, 85, 0.05);
}
```

## 実装上の注意点

### 1. 既存のJavaScriptとの互換性

Redmineには、フォームの機能性を保証するJavaScriptが含まれています：

```javascript
$(document).ready(function(){
  $("#issue_tracker_id, #issue_status_id").each(function(){
    $(this).val($(this).find("option[selected=selected]").val());
  });
  // 他のコード
});
```

**注意点**：
- このスクリプトの動作を妨げないようにする
- DOMセレクタが機能するようにHTML構造を維持する

### 2. カスタムフィールドの対応

Redmineではプロジェクトごとにカスタムフィールドが設定されている場合があります。

**注意点**：
- カスタムフィールドも一貫したスタイルで表示されるようにする
- `.attributes`セレクタのスタイルを適用してカスタムフィールドもカバーする

### 3. 日付ピッカーのカスタマイズ

Redmineは日付入力にjQuery UIのDatepickerを使用しています：

```javascript
$(function() { 
  $('#issue_start_date').addClass('date').datepickerFallback(datepickerOptions); 
});
```

**注意点**：
- jQuery UIのDatepickerのスタイルをLINEデザイン言語に合わせてカスタマイズする
- モバイルでは`type="date"`の入力を優先的に使用するようにする

### 4. フォーム検証エラーのスタイリング

エラー時のスタイルも考慮する必要があります：

```css
/* エラー表示 */
.box.tabular label.error {
  color: var(--line-error);
}

.box.tabular input.error,
.box.tabular select.error,
.box.tabular textarea.error {
  border-color: var(--line-error);
  background-color: rgba(255, 59, 48, 0.05);
}

.flash.error {
  background-color: rgba(255, 59, 48, 0.1);
  color: var(--line-error);
  border: 1px solid var(--line-error);
  border-radius: var(--border-radius-small);
  padding: 10px 15px;
  margin-bottom: 20px;
}
```

## まとめ

新規チケット作成画面は、既存のHTML構造を保持したまま、CSSのみでLINEデザイン言語に合わせることが可能です。主な対応点は次のとおりです：

1. フォーム要素をカード型UIとして表示
2. レスポンシブなレイアウトの実現
3. フォーム各要素のスタイリング統一
4. ユーザーアクションに対するフィードバックの改善
5. モバイル環境での使いやすさの向上

これらの改善により、ユーザーエクスペリエンスを大幅に向上させつつ、Redmineの基本機能を保持することができます。
