# Redmineテーマの構造と最適化計画

## 標準的なRedmineテーマの構造

Redmineのテーマは通常、以下のような構造を持ちます：

```
public/themes/[theme_name]/
├── stylesheets/
│   ├── application.css       # メインのスタイルシート
│   ├── rtl.css               # 右から左へ読む言語用（オプション）
│   └── [その他のCSS]
├── javascripts/
│   └── theme.js              # テーマ用JavaScript
├── images/                   # テーマ用画像
│   ├── logo.png
│   └── [その他の画像]
└── theme.json                # テーマのメタデータ
```

## Redmineのテーマ適用の仕組み

Redmineのテーマは、既存のHTMLの構造を変更せず、主にCSSの上書きによって適用されます。JavaScriptは追加機能のために使用されますが、DOM構造を大幅に変更するのは推奨されていません。

### 重要ポイント

1. Redmineの元のHTMLは保持したまま、CSSで見た目を変更する
2. クラス名やID名は既存のものを利用する
3. 必要な場合のみ、JavaScriptでDOM操作を行う

## 最適化計画

現在作成したLINE風テーマの実装を、Redmine標準のテーマ構造に最適化するステップを以下に示します：

### 1. CSS最適化

1. **共通CSSの抽出**
   - 変数定義
   - リセットスタイル
   - 共通コンポーネント（ヘッダー、サイドバー、フッター）のスタイル
   
2. **ページ固有のCSSの分離**
   - `issues.css` - チケット一覧と詳細ページ用
   - `responsive.css` - レスポンシブデザイン用

### 2. JavaScript最適化

1. **共通関数の抽出**
   - ドロワー操作
   - タブ操作
   - クリックイベント処理

2. **不要な重複処理の削除**
   - 同一セレクタへの複数の処理

### 3. HTML変更の最小化

Redmineのテーマでは、HTMLを大幅に変更することは難しいため、以下の方針で対応します：

1. **既存の構造を活かしたCSSスタイリング**
   - 既存のクラスを活用したデザイン
   - 追加クラスは最小限に

2. **必要な場合のみのDOM操作**
   - JavaScriptによる要素の追加・変更
   - `document.ready` でのHTML構造の拡張

## ファイル分割計画

### 1. application.css

```css
/* 変数定義 */
:root {
  --line-primary: #06C755;
  --line-secondary: #1E1E1E;
  /* 他の変数 */
}

/* リセットスタイル */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

/* 基本レイアウト */
body {
  font-family: 'Noto Sans JP', sans-serif;
  background-color: var(--line-background);
  /* 他のスタイル */
}

/* ヘッダー */
#top-menu {
  background-color: var(--line-primary);
  /* LINEスタイルのヘッダー */
}

/* 左サイドバー */
#main-menu {
  /* LINEスタイルのサイドバー */
}

/* フッター */
#footer {
  /* LINEスタイルのフッター */
}
```

### 2. issues.css

```css
/* チケット一覧テーブル */
table.list.issues {
  /* チケット一覧のスタイル */
}

/* チケット詳細 */
div.issue {
  /* チケット詳細のスタイル */
}

/* フィルター */
fieldset#filters {
  /* フィルターのスタイル */
}

/* その他チケット関連のスタイル */
```

### 3. theme.js

```javascript
$(document).ready(function() {
  // ヘッダーの拡張
  setupHeader();
  
  // サイドバーの拡張
  setupSidebar();
  
  // フッターの拡張
  setupFooter();
  
  // その他の機能拡張
  setupTabNavigation();
  setupDrawerBehavior();
  setupAnimations();
});

// 各種セットアップ関数
function setupHeader() {
  // ヘッダーの拡張処理
}

function setupSidebar() {
  // サイドバーの拡張処理
}

// その他の関数
```

## 実装方針

1. **既存のHTMLを変更しない**
   - Redmineの標準HTML構造を保持
   - 必要に応じてJavaScriptでDOM要素を追加

2. **既存のクラス・IDを最大限活用**
   - Redmine標準のクラス名をスタイリングに利用
   - 必要な場合のみ追加クラスを付与

3. **段階的な適用を可能に**
   - コア機能に影響しない実装
   - 拡張機能は段階的に追加できるように

## 実装優先順位

1. 基本レイアウト（ヘッダー、サイドバー、フッター）
2. チケット一覧ページ
3. チケット詳細ページ
4. その他の拡張機能

この計画に沿って、LINE風テーマをRedmineに最適化して実装していきます。
