-- /root/projects/rental-system/db/sql/initial_data.sql
-- 機材予約システム 初期データ投入スクリプト

-- ======================================
-- 管理者ユーザー作成
-- ======================================
INSERT OR REPLACE INTO users (id, username, password, name, department, email, role, notification_enabled) VALUES
(1, 'admin', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', '管理者', 'システム管理部', 'admin@call2arm.com', 'admin', 1),
(2, 'system', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', 'システム', 'システム管理部', 'system@call2arm.com', 'admin', 1);

-- パスワード: admin123 (本番環境では変更必須)
-- ハッシュ生成コマンド: node -e "console.log(require('bcrypt').hashSync('admin123', 12))"

-- ======================================
-- サンプルユーザー作成
-- ======================================
INSERT OR REPLACE INTO users (username, password, name, department, email, role, notification_enabled) VALUES
('yamada', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', '山田太郎', '技術部', 'yamada@call2arm.com', 'user', 1),
('suzuki', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', '鈴木花子', '制作部', 'suzuki@call2arm.com', 'user', 1),
('tanaka', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', '田中次郎', '営業部', 'tanaka@call2arm.com', 'user', 1),
('sato', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', '佐藤美咲', 'マーケティング部', 'sato@call2arm.com', 'user', 1),
('takahashi', '$2b$12$LQv3c1yqBwlVHpPjrGNDT.kzRGHJ3fN4FMrOV5.Kg0L8q9X1X9X1X', '高橋健一', '総務部', 'takahashi@call2arm.com', 'user', 1);

-- ======================================
-- 機材カテゴリ投入
-- ======================================
INSERT OR REPLACE INTO categories (id, name, description, icon) VALUES
(1, 'カメラ機材', '撮影用カメラ及び関連機材', '📷'),
(2, '音響機材', '音声録音・再生関連機材', '🎤'),
(3, '照明機材', '撮影・イベント用照明機材', '💡'),
(4, 'IT機材', 'コンピューター・ネットワーク関連機材', '💻');

-- ======================================
-- 機材サブカテゴリ投入
-- ======================================
-- カメラ機材 (1)
INSERT OR REPLACE INTO subcategories (id, category_id, name, description) VALUES
(1, 1, 'デジタルカメラ', 'ミラーレス・一眼レフカメラ'),
(2, 1, 'ビデオカメラ', '動画撮影専用カメラ'),
(3, 1, 'アクションカメラ', '小型・防水・高耐久カメラ'),
(4, 1, 'ドローンカメラ', '空撮用ドローン・カメラ'),
(5, 1, 'レンズ', '交換レンズ・フィルター'),
(6, 1, '三脚', 'カメラ支持・安定化機材'),
(7, 1, 'ジンバル', '手ぶれ補正・スタビライザー'),
(8, 1, 'フィルター', 'レンズフィルター・エフェクト'),
(9, 1, 'バッテリー', 'カメラ用電源・充電器'),
(10, 1, '記録メディア', 'SDカード・ストレージ');

-- 音響機材 (2)
INSERT OR REPLACE INTO subcategories (id, category_id, name, description) VALUES
(11, 2, 'マイクロフォン', '各種マイク・集音機器'),
(12, 2, 'レコーダー', '音声録音・再生機器'),
(13, 2, 'ミキサー', '音声調整・編集機器'),
(14, 2, 'スピーカー', '音声出力・拡声機器'),
(15, 2, 'ヘッドフォン', '音声監視・編集用'),
(16, 2, 'オーディオケーブル', '音声接続・伝送ケーブル'),
(17, 2, 'ワイヤレス機材', '無線音声伝送システム'),
(18, 2, 'アンプ', '音声増幅・駆動機器'),
(19, 2, 'エフェクター', '音声効果・加工機器'),
(20, 2, '音響アクセサリー', 'その他音響関連機材');

-- 照明機材 (3)
INSERT OR REPLACE INTO subcategories (id, category_id, name, description) VALUES
(21, 3, 'LEDライト', 'LED照明・パネル'),
(22, 3, 'スタジオライト', 'スタジオ用大型照明'),
(23, 3, 'ポータブルライト', '携帯・小型照明機器'),
(24, 3, 'リフレクター', '光反射・拡散板'),
(25, 3, 'ディフューザー', '光柔和・拡散機材'),
(26, 3, 'ライトスタンド', '照明支持・調整スタンド'),
(27, 3, 'カラーフィルター', '色温度・色彩調整フィルター'),
(28, 3, '調光器', '明度・光量調整機器'),
(29, 3, 'バックドロップ', '背景・撮影用背景幕'),
(30, 3, '照明アクセサリー', 'その他照明関連機材');

-- IT機材 (4)
INSERT OR REPLACE INTO subcategories (id, category_id, name, description) VALUES
(31, 4, 'ノートPC', 'ポータブル・ラップトップPC'),
(32, 4, 'タブレット', 'タブレット・iPad等'),
(33, 4, 'モニター', '外部ディスプレイ・モニター'),
(34, 4, 'プロジェクター', 'プレゼン・投影機器'),
(35, 4, 'ネットワーク機器', 'ルーター・スイッチ・AP'),
(36, 4, 'ストレージ', '外部・ネットワークストレージ'),
(37, 4, 'ケーブル類', '各種接続・変換ケーブル'),
(38, 4, '変換アダプター', 'インターフェース変換機器'),
(39, 4, 'テスト機器', '測定・検証・試験機器'),
(40, 4, 'その他IT機材', 'その他IT・OA機器');

-- ======================================
-- サンプル機材データ投入
-- ======================================
-- カメラ機材
INSERT OR REPLACE INTO equipment (id, name, category_id, subcategory_id, status, location, specifications, purchase_date, last_maintenance) VALUES
-- デジタルカメラ
('1-01-001', 'Sony α7R V', 1, 1, 'available', '倉庫1-A', '6100万画素、感度ISO 100-32000、4K動画対応', '2024-01-15', '2024-12-01'),
('1-01-002', 'Canon EOS R5', 1, 1, 'available', '倉庫1-A', '4500万画素、感度ISO 100-25600、8K動画対応', '2024-02-20', '2024-11-15'),
('1-01-003', 'Nikon Z9', 1, 1, 'available', '倉庫1-A', '4571万画素、感度ISO 64-25600、8K動画対応', '2024-03-10', '2024-10-30'),
('1-01-004', 'Fujifilm X-T5', 1, 1, 'maintenance', '倉庫1-A', '4020万画素、APS-Cセンサー、4K動画対応', '2024-04-05', '2024-09-20'),

-- ビデオカメラ
('1-02-001', 'Sony FX6', 1, 2, 'available', '倉庫1-B', 'フルサイズ、6K収録、デュアルベースISO', '2024-01-20', '2024-11-20'),
('1-02-002', 'Canon C70', 1, 2, 'available', '倉庫1-B', 'Super35mm、4K DCI、デュアルピクセルAF', '2024-02-15', '2024-10-25'),
('1-02-003', 'Panasonic GH6', 1, 2, 'available', '倉庫1-B', 'Micro Four Thirds、5.7K収録', '2024-03-20', '2024-09-30'),

-- レンズ
('1-05-001', 'Sony FE 24-70mm F2.8 GM II', 1, 5, 'available', '倉庫1-E', '標準ズームレンズ、Gマスター', '2024-01-25', '2024-11-10'),
('1-05-002', 'Canon RF 70-200mm F2.8L IS USM', 1, 5, 'available', '倉庫1-E', '望遠ズームレンズ、手ぶれ補正', '2024-02-10', '2024-10-15'),
('1-05-003', 'Nikon NIKKOR Z 85mm f/1.8 S', 1, 5, 'available', '倉庫1-E', '中望遠単焦点レンズ', '2024-03-15', '2024-09-25');

-- 音響機材
INSERT OR REPLACE INTO equipment (id, name, category_id, subcategory_id, status, location, specifications, purchase_date, last_maintenance) VALUES
-- マイクロフォン
('2-01-001', 'SHURE SM7B', 2, 11, 'available', '倉庫2-A', 'ダイナミックマイク、放送用、周波数特性50Hz-20kHz', '2024-01-10', '2024-11-05'),
('2-01-002', 'Audio-Technica AT2020', 2, 11, 'available', '倉庫2-A', 'コンデンサーマイク、カーディオイド、ファンタム電源', '2024-02-05', '2024-10-20'),
('2-01-003', 'RODE VideoMic Pro Plus', 2, 11, 'available', '倉庫2-A', 'ショットガンマイク、カメラ用、内蔵充電池', '2024-03-12', '2024-09-18'),

-- レコーダー
('2-02-001', 'ZOOM H6', 2, 12, 'available', '倉庫2-B', '6トラック同時録音、XLR/TRS入力', '2024-01-18', '2024-11-12'),
('2-02-002', 'TASCAM DR-40X', 2, 12, 'available', '倉庫2-B', '4トラック録音、USB/AC電源', '2024-02-22', '2024-10-08'),

-- スピーカー
('2-04-001', 'YAMAHA HS8', 2, 14, 'available', '倉庫2-D', 'アクティブモニタースピーカー、8インチ', '2024-01-30', '2024-11-18'),
('2-04-002', 'JBL LSR305P MkII', 2, 14, 'available', '倉庫2-D', 'アクティブスタジオモニター、5インチ', '2024-02-25', '2024-10-12');

-- 照明機材
INSERT OR REPLACE INTO equipment (id, name, category_id, subcategory_id, status, location, specifications, purchase_date, last_maintenance) VALUES
-- LEDライト
('3-01-001', 'Aputure LS 300X', 3, 21, 'available', '倉庫3-A', '300W LEDライト、色温度2700K-6500K可変', '2024-01-12', '2024-11-08'),
('3-01-002', 'Godox SL-60W', 3, 21, 'available', '倉庫3-A', '60W LEDライト、5600K、Bowensマウント', '2024-02-18', '2024-10-22'),
('3-01-003', 'Neewer 660 RGB', 3, 21, 'available', '倉庫3-A', 'RGB LEDパネル、660球、アプリ制御', '2024-03-25', '2024-09-15'),

-- ライトスタンド
('3-06-001', 'Manfrotto 1004BAC', 3, 26, 'available', '倉庫3-F', 'マスターライトスタンド、高さ3.6m', '2024-01-20', '2024-11-15'),
('3-06-002', 'Neewer 210cm', 3, 26, 'available', '倉庫3-F', 'アルミ製ライトスタンド、高さ2.1m', '2024-02-15', '2024-10-28');

-- IT機材
INSERT OR REPLACE INTO equipment (id, name, category_id, subcategory_id, status, location, specifications, purchase_date, last_maintenance) VALUES
-- ノートPC
('4-01-001', 'MacBook Pro 16" M2 Max', 4, 31, 'available', '倉庫4-A', 'Apple M2 Max、32GB RAM、1TB SSD', '2024-01-15', '2024-11-10'),
('4-01-002', 'ThinkPad X1 Carbon Gen 11', 4, 31, 'available', '倉庫4-A', 'Intel Core i7、16GB RAM、512GB SSD', '2024-02-20', '2024-10-18'),
('4-01-003', 'Dell XPS 15 9530', 4, 31, 'maintenance', '倉庫4-A', 'Intel Core i7、32GB RAM、1TB SSD、RTX 4060', '2024-03-10', '2024-09-22'),

-- モニター
('4-03-001', 'LG 27UP850-W', 4, 33, 'available', '倉庫4-C', '27インチ 4K USB-C、HDR400', '2024-01-25', '2024-11-05'),
('4-03-002', 'ASUS ProArt PA278CV', 4, 33, 'available', '倉庫4-C', '27インチ WQHD、USB-C、カラーキャリブレーション', '2024-02-12', '2024-10-30'),

-- プロジェクター
('4-04-001', 'EPSON EB-L200X', 4, 34, 'available', '倉庫4-D', 'レーザー光源、4200lm、XGA', '2024-01-30', '2024-11-20'),
('4-04-002', 'BenQ TK700STi', 4, 34, 'available', '倉庫4-D', '4K HDR、短焦点、3000lm、ゲーミング対応', '2024-03-05', '2024-09-28');

-- ======================================
-- Bot設定初期データ
-- ======================================
INSERT OR REPLACE INTO bot_settings (setting_key, setting_value, description) VALUES
('bot_name', '機材予約Bot', 'LINE WORKS Botの表示名'),
('bot_version', '1.0.0', 'Botのバージョン'),
('welcome_message', 'こんにちは！機材予約システムへようこそ🎉

📱 スマートフォンから簡単に機材の検索・予約ができます
🔍 人気機材やカテゴリ別検索も可能
📅 予約状況の確認・変更もお任せください

使い方：
・「予約」「検索」「確認」などのキーワードを入力
・機材名を直接入力して検索
・「ヘルプ」で詳しい使い方を確認

🔗 Webで開く: https://rental.call2arm.com', '初回ログイン時のウェルカムメッセージ'),

('reservation_created_template', '📋 予約が完了しました！

🎯 機材: {equipment_name}
📅 期間: {start_date} ～ {end_date}
🏢 場所: {location}
💼 目的: {purpose}

✅ 予約ID: #{reservation_id}

🔗 詳細確認: https://rental.call2arm.com/reservations/{reservation_id}', '予約作成時の通知テンプレート'),

('reminder_template', '⏰ 予約リマインダー

明日から以下の機材をご利用いただけます：

🎯 {equipment_name}
📅 {start_date} ～ {end_date}
🏢 場所: {location}

準備をお忘れなく！

🔗 予約詳細: https://rental.call2arm.com/reservations/{reservation_id}', '予約リマインダーテンプレート'),

('cancellation_template', '❌ 予約がキャンセルされました

🎯 機材: {equipment_name}
📅 期間: {start_date} ～ {end_date}

キャンセル理由: {reason}

🔗 新しい予約: https://rental.call2arm.com', '予約キャンセル時のテンプレート'),

('maintenance_template', '🔧 メンテナンス予定のお知らせ

以下の機材がメンテナンス予定です：

🎯 {equipment_name}
📅 メンテナンス期間: {maintenance_start} ～ {maintenance_end}

該当期間は予約できませんのでご注意ください。

🔗 代替機材を探す: https://rental.call2arm.com/search?category={category}', 'メンテナンス通知テンプレート'),

('help_message', '🤖 機材予約システム Bot ヘルプ

📋 利用可能なコマンド：

📱 「予約」- 新しい予約を作成
🔍 「検索」- 機材を検索
📋 「確認」- 予約状況を確認
⭐「人気」- 人気機材を表示
❓ 「ヘルプ」- このメッセージを表示

💡 機材名を直接入力して検索することも可能です！
例：「カメラ」「マイク」「LED」

🔗 Webで開く: https://rental.call2arm.com', 'ヘルプメッセージ'),

('error_message', '申し訳ございません。エラーが発生しました。

しばらく時間をおいてから再度お試しください。
問題が続く場合は、管理者にお問い合わせください。

🔗 Webで開く: https://rental.call2arm.com', 'エラー時のメッセージ'),

('schema_version', '1.0.0', 'データベーススキーマバージョン'),
('system_status', 'active', 'システム稼働状態'),
('last_updated', datetime('now'), '最終更新日時');

-- ======================================
-- ユーザー通知設定初期化
-- ======================================
INSERT OR REPLACE INTO user_notification_settings (user_id, reservation_reminders, maintenance_notifications, popular_equipment_alerts, system_announcements, reminder_days_before)
SELECT id, 1, 1, 0, 1, 1 FROM users;

-- ======================================
-- システム初期化完了ログ
-- ======================================
INSERT INTO notification_history (user_id, notification_type, title, message, delivery_status)
VALUES (1, 'system_init', 'システム初期化完了', 'rental.call2arm.com の機材予約システムが正常に初期化されました。', 'sent');

-- ======================================
-- 初期化完了確認
-- ======================================
-- 統計情報表示
SELECT 
    'カテゴリ数' as item, COUNT(*) as count FROM categories
UNION ALL
SELECT 
    'サブカテゴリ数', COUNT(*) FROM subcategories
UNION ALL
SELECT 
    '機材数', COUNT(*) FROM equipment
UNION ALL
SELECT 
    'ユーザー数', COUNT(*) FROM users
UNION ALL
SELECT 
    '利用可能機材数', COUNT(*) FROM equipment WHERE status = 'available'
UNION ALL
SELECT 
    'Bot設定数', COUNT(*) FROM bot_settings;

-- データ整合性確認
PRAGMA integrity_check;

-- インデックス確認
PRAGMA index_list(equipment);
PRAGMA index_list(reservations);

-- 初期化完了メッセージ
SELECT 
    '🎉 機材予約システム初期化完了！' as message,
    'rental.call2arm.com で利用開始可能です' as status,
    datetime('now', 'localtime') as initialized_at;