# /root/projects/rental-system/.env.production
# 機材予約システム 本番環境設定ファイル

# ======================================
# アプリケーション基本設定
# ======================================
NODE_ENV=production
PORT=3000
APP_NAME=機材予約システム
APP_URL=https://rental.call2arm.com
APP_VERSION=1.0.0
COMPANY_NAME=株式会社サンプル
COMPANY_DOMAIN=call2arm.com

# ======================================
# データベース設定
# ======================================
DB_PATH=/app/data/rental_system.db
DB_TIMEOUT=30000
DB_MAX_CONNECTIONS=10
DB_POOL_SIZE=5
DB_BACKUP_ENABLED=true
DB_BACKUP_INTERVAL=86400000
DB_VACUUM_INTERVAL=604800000

# ======================================
# JWT認証設定
# ======================================
# 本番環境では以下を強力なランダム文字列に変更
JWT_SECRET=CHANGE_THIS_TO_RANDOM_SECRET_64_CHARS_FOR_PRODUCTION_USE_ONLY
JWT_EXPIRES_IN=24h
JWT_REFRESH_EXPIRES_IN=7d
JWT_ISSUER=rental.call2arm.com
JWT_AUDIENCE=rental-system-users

# ======================================
# セッション設定
# ======================================
# 本番環境では以下を強力なランダム文字列に変更
SESSION_SECRET=CHANGE_THIS_TO_RANDOM_SESSION_SECRET_32_CHARS_PRODUCTION
SESSION_TIMEOUT=1800000
SESSION_SECURE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=strict

# ======================================
# LINE WORKS OAuth設定
# ======================================
# 実際の値はLINE WORKS Developer Consoleから取得
LINEWORKS_CLIENT_ID=YOUR_ACTUAL_LINEWORKS_CLIENT_ID
LINEWORKS_CLIENT_SECRET=YOUR_ACTUAL_LINEWORKS_CLIENT_SECRET
LINEWORKS_REDIRECT_URI=https://rental.call2arm.com/auth/callback
LINEWORKS_SCOPE=openid profile user
LINEWORKS_AUTH_URL=https://auth.worksmobile.com/oauth2/v2.0/authorize
LINEWORKS_TOKEN_URL=https://auth.worksmobile.com/oauth2/v2.0/token
LINEWORKS_USER_INFO_URL=https://www.worksapis.com/v1.0/users/me

# ======================================
# LINE WORKS Bot設定
# ======================================
# 実際の値はLINE WORKS Developer Consoleから取得
LINEWORKS_BOT_ID=YOUR_ACTUAL_BOT_ID
LINEWORKS_BOT_SECRET=YOUR_ACTUAL_BOT_SECRET
LINEWORKS_BOT_ACCESS_TOKEN=YOUR_ACTUAL_BOT_ACCESS_TOKEN
LINEWORKS_BOT_API_URL=https://www.worksapis.com/v1.0
LINEWORKS_WEBHOOK_VERIFY=true

# ======================================
# セキュリティ設定
# ======================================
BCRYPT_ROUNDS=12
RATE_LIMIT_WINDOW_MS=900000
RATE_LIMIT_MAX_REQUESTS=100
RATE_LIMIT_SKIP_SUCCESSFUL_REQUESTS=false

# CORS設定
CORS_ORIGIN=https://rental.call2arm.com
CORS_CREDENTIALS=true
CORS_METHODS=GET,POST,PUT,DELETE,OPTIONS
CORS_ALLOWED_HEADERS=Content-Type,Authorization,X-Requested-With

# IP制限設定（カンマ区切り、本番では社内IPに限定）
ALLOWED_IPS=0.0.0.0/0
# ALLOWED_IPS=192.168.0.0/16,10.0.0.0/8,172.16.0.0/12

# XSS保護
XSS_PROTECTION=true
CONTENT_TYPE_NOSNIFF=true
FRAME_OPTIONS=DENY

# ======================================
# ログ設定
# ======================================
LOG_LEVEL=info
LOG_FILE=/app/logs/application.log
LOG_MAX_SIZE=10485760
LOG_MAX_FILES=5
LOG_DATE_PATTERN=YYYY-MM-DD
LOG_ZIP_ARCHIVED=true

# アクセスログ
ACCESS_LOG_ENABLED=true
ACCESS_LOG_FILE=/app/logs/access.log
ACCESS_LOG_FORMAT=combined

# エラーログ
ERROR_LOG_ENABLED=true
ERROR_LOG_FILE=/app/logs/error.log
ERROR_LOG_STACK_TRACE=false

# デバッグログ（本番では無効）
DEBUG_MODE=false
VERBOSE_LOGGING=false
SQL_LOGGING=false

# ======================================
# ファイルアップロード設定
# ======================================
UPLOAD_MAX_SIZE=52428800
UPLOAD_ALLOWED_TYPES=image/jpeg,image/png,image/gif,image/webp,application/pdf,text/csv
UPLOAD_DIR=/app/uploads
UPLOAD_TEMP_DIR=/app/temp
UPLOAD_CLEANUP_INTERVAL=3600000

# 画像処理
IMAGE_RESIZE_ENABLED=true
IMAGE_MAX_WIDTH=1920
IMAGE_MAX_HEIGHT=1080
IMAGE_QUALITY=85

# ======================================
# 通知設定
# ======================================
NOTIFICATION_ENABLED=true
NOTIFICATION_QUEUE_ENABLED=true
NOTIFICATION_RETRY_ATTEMPTS=3
NOTIFICATION_RETRY_DELAY=5000

# リマインダー設定
REMINDER_ENABLED=true
REMINDER_HOURS_BEFORE=24
REMINDER_SCHEDULE=0 9 * * *

# 通知制限
MAX_NOTIFICATIONS_PER_USER_PER_DAY=20
MAX_NOTIFICATIONS_PER_HOUR=5
NOTIFICATION_RATE_LIMIT=true

# ======================================
# 予約システム設定
# ======================================
# 予約制限
MAX_RESERVATION_DAYS=30
MAX_RESERVATIONS_PER_USER=10
MIN_RESERVATION_HOURS=1
MAX_RESERVATION_HOURS=168

# 予約変更制限
RESERVATION_CHANGE_DEADLINE_HOURS=72
RESERVATION_CANCEL_DEADLINE_HOURS=24

# 営業日設定
BUSINESS_DAYS=1,2,3,4,5
BUSINESS_HOURS_START=09:00
BUSINESS_HOURS_END=18:00

# ======================================
# メンテナンス設定
# ======================================
MAINTENANCE_MODE=false
MAINTENANCE_MESSAGE=システムメンテナンス中です。しばらくお待ちください。
MAINTENANCE_START_TIME=
MAINTENANCE_END_TIME=

# アーカイブ設定
ARCHIVE_ENABLED=true
ARCHIVE_SCHEDULE=0 3 * * 0
ARCHIVE_RETENTION_MONTHS=3

# ======================================
# バックアップ設定
# ======================================
BACKUP_ENABLED=true
BACKUP_SCHEDULE=0 2 * * *
BACKUP_RETENTION_DAYS=30
BACKUP_DIR=/app/backup
BACKUP_COMPRESSION=true

# 外部バックアップ（オプション）
EXTERNAL_BACKUP_ENABLED=false
EXTERNAL_BACKUP_S3_BUCKET=
EXTERNAL_BACKUP_S3_REGION=
EXTERNAL_BACKUP_S3_ACCESS_KEY=
EXTERNAL_BACKUP_S3_SECRET_KEY=

# ======================================
# 監視・メトリクス設定
# ======================================
HEALTH_CHECK_ENABLED=true
HEALTH_CHECK_ENDPOINT=/health
HEALTH_CHECK_TIMEOUT=5000

# メトリクス収集
METRICS_ENABLED=true
METRICS_PORT=9090
METRICS_ENDPOINT=/metrics

# パフォーマンス監視
PERFORMANCE_MONITORING=true
SLOW_QUERY_THRESHOLD=1000
MEMORY_USAGE_ALERT_THRESHOLD=85

# ======================================
# キャッシュ設定
# ======================================
CACHE_ENABLED=true
CACHE_TTL=3600
CACHE_MAX_SIZE=1000
CACHE_TYPE=memory

# 静的ファイルキャッシュ
STATIC_CACHE_ENABLED=true
STATIC_CACHE_MAX_AGE=2592000
STATIC_CACHE_IMMUTABLE=true

# API レスポンスキャッシュ
API_CACHE_ENABLED=false
API_CACHE_TTL=300

# ======================================
# パフォーマンス設定
# ======================================
# 圧縮設定
COMPRESSION_ENABLED=true
COMPRESSION_LEVEL=6
COMPRESSION_THRESHOLD=1024

# クラスタリング（本番負荷に応じて調整）
CLUSTER_ENABLED=false
CLUSTER_WORKERS=auto

# Keep-Alive設定
KEEP_ALIVE_TIMEOUT=5000
HEADERS_TIMEOUT=60000

# ======================================
# デバッグ・開発設定（本番では無効）
# ======================================
DEBUG_MODE=false
DEVELOPMENT_MODE=false
HOT_RELOAD=false
SOURCE_MAPS=false

# プロファイリング（本番では無効）
PROFILING_ENABLED=false
CPU_PROFILING=false
MEMORY_PROFILING=false

# ======================================
# 外部サービス連携（将来拡張用）
# ======================================
# メール通知（将来実装）
EMAIL_ENABLED=false
SMTP_HOST=
SMTP_PORT=587
SMTP_SECURE=true
SMTP_USER=
SMTP_PASS=
EMAIL_FROM=noreply@call2arm.com

# Slack通知（将来実装）
SLACK_ENABLED=false
SLACK_WEBHOOK_URL=
SLACK_CHANNEL=#general

# Teams通知（将来実装）
TEAMS_ENABLED=false
TEAMS_WEBHOOK_URL=

# ======================================
# システム情報・メタデータ
# ======================================
DEPLOYMENT_DATE=2025-06-18
DEPLOYED_BY=development-team
ENVIRONMENT=production
SERVER_LOCATION=VPS-root
TIMEZONE=Asia/Tokyo

# Git情報（デプロイ時に設定）
GIT_COMMIT_HASH=
GIT_BRANCH=main
GIT_TAG=v1.0.0

# ======================================
# 注意事項・セキュリティ
# ======================================
# 
# 🔒 セキュリティ重要事項:
# 1. JWT_SECRET と SESSION_SECRET は本番環境で必ず変更すること
# 2. LINE WORKS の実際のクライアントID・シークレットを設定すること
# 3. ALLOWED_IPS を社内ネットワークに限定すること（必要に応じて）
# 4. このファイルの権限を 600 (所有者のみ読み書き) に設定すること
# 5. 定期的にシークレットキーのローテーションを実施すること
#
# 🔧 設定変更後の作業:
# 1. docker-compose down && docker-compose up -d
# 2. nginx -t && systemctl reload nginx
# 3. 動作確認とログチェック
#
# 📋 監視項目:
# 1. /health エンドポイントの応答確認
# 2. /var/log/nginx/rental.call2arm.com.*.log の確認
# 3. docker-compose logs rental-app の確認
# 4. システムリソース使用量の確認