# 関数・APIエンドポイント詳細仕様書

## 1. 認証関連

### 1.1 関数仕様

#### AUTH-001: registerUser
| 項目 | 内容 |
|------|------|
| **ID** | AUTH-001 |
| **名称** | ユーザー登録 |
| **説明** | 新規ユーザーアカウントを作成する |
| **入力値** | `UserRegistrationData: { email: string, password: string, userType: 'landlord' \| 'tenant', phone?: string, preferredLanguage?: string }` |
| **出力値** | `Promise<User: { id: string, email: string, userType: string, createdAt: Date }>` |
| **処理内容** | 1. 入力データバリデーション<br>2. メールアドレス重複チェック<br>3. パスワードハッシュ化<br>4. ユーザーレコード作成<br>5. 認証トークン生成<br>6. 確認メール送信 |

#### AUTH-002: authenticateUser
| 項目 | 内容 |
|------|------|
| **ID** | AUTH-002 |
| **名称** | ユーザー認証 |
| **説明** | ログイン認証を行いトークンを発行する |
| **入力値** | `email: string, password: string` |
| **出力値** | `Promise<AuthResult: { user: User, accessToken: string, refreshToken: string }>` |
| **処理内容** | 1. ユーザー存在確認<br>2. パスワード照合<br>3. アカウント状態確認<br>4. JWTトークン生成<br>5. ログイン履歴記録 |

#### AUTH-003: generateToken
| 項目 | 内容 |
|------|------|
| **ID** | AUTH-003 |
| **名称** | JWTトークン生成 |
| **説明** | ユーザー認証用のJWTトークンを生成する |
| **入力値** | `userId: string, role: UserRole, expiresIn?: string` |
| **出力値** | `string` |
| **処理内容** | 1. ペイロード構築<br>2. 秘密鍵での署名<br>3. 有効期限設定<br>4. トークン返却 |

### 1.2 APIエンドポイント仕様

#### API-001: /api/auth/register
| 項目 | 内容 |
|------|------|
| **API ID** | API-001 |
| **エンドポイント** | /api/auth/register |
| **メソッド** | POST |
| **説明** | 新規ユーザー登録 |
| **入力値** | ```json<br>{<br>  "email": "user@example.com",<br>  "password": "password123",<br>  "userType": "tenant",<br>  "phone": "+81-90-1234-5678",<br>  "preferredLanguage": "ja"<br>}``` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "user": {<br>      "id": "uuid",<br>      "email": "user@example.com",<br>      "userType": "tenant"<br>    },<br>    "accessToken": "jwt_token",<br>    "refreshToken": "refresh_token"<br>  }<br>}``` |
| **処理内容** | 1. リクエストボディ検証<br>2. AUTH-001関数呼び出し<br>3. レスポンス整形<br>4. HTTPステータス設定 |

#### API-002: /api/auth/login
| 項目 | 内容 |
|------|------|
| **API ID** | API-002 |
| **エンドポイント** | /api/auth/login |
| **メソッド** | POST |
| **説明** | ユーザーログイン |
| **入力値** | ```json<br>{<br>  "email": "user@example.com",<br>  "password": "password123"<br>}``` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "user": {<br>      "id": "uuid",<br>      "email": "user@example.com",<br>      "userType": "tenant"<br>    },<br>    "accessToken": "jwt_token",<br>    "refreshToken": "refresh_token"<br>  }<br>}``` |
| **処理内容** | 1. ログイン情報検証<br>2. AUTH-002関数呼び出し<br>3. セッション管理<br>4. セキュリティログ記録 |

## 2. 物件管理関連

### 2.1 関数仕様

#### PROP-001: createProperty
| 項目 | 内容 |
|------|------|
| **ID** | PROP-001 |
| **名称** | 物件作成 |
| **説明** | 新規物件情報を登録する |
| **入力値** | ```typescript<br>PropertyData: {<br>  title: string,<br>  description: string,<br>  propertyType: string,<br>  rentAmount: number,<br>  address: Address,<br>  amenities: string[],<br>  images?: File[]<br>}``` |
| **出力値** | `Promise<Property>` |
| **処理内容** | 1. 物件データ検証<br>2. 住所ジオコーディング<br>3. 物件レコード作成<br>4. 設備情報登録<br>5. 画像処理・保存<br>6. 検索インデックス更新 |

#### PROP-004: getProperty
| 項目 | 内容 |
|------|------|
| **ID** | PROP-004 |
| **名称** | 物件取得 |
| **説明** | 指定されたIDの物件情報を取得する |
| **入力値** | `id: string, language?: string` |
| **出力値** | `Promise<Property \| null>` |
| **処理内容** | 1. 物件ID検証<br>2. データベースクエリ実行<br>3. 多言語対応処理<br>4. 関連データ結合<br>5. 閲覧履歴記録 |

### 2.2 APIエンドポイント仕様

#### API-012: /api/properties
| 項目 | 内容 |
|------|------|
| **API ID** | API-012 |
| **エンドポイント** | /api/properties |
| **メソッド** | POST |
| **説明** | 物件新規登録 |
| **入力値** | ```json<br>{<br>  "title": "築浅1K アパート",<br>  "description": "駅徒歩5分の好立地",<br>  "propertyType": "apartment",<br>  "rentAmount": 55000,<br>  "address": {<br>    "prefecture": "群馬県",<br>    "city": "前橋市",<br>    "detail": "○○町1-2-3"<br>  },<br>  "amenities": ["wifi", "aircon"]<br>}``` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "id": "property_uuid",<br>    "title": "築浅1K アパート",<br>    "rentAmount": 55000,<br>    "status": "draft",<br>    "createdAt": "2025-06-19T10:00:00Z"<br>  }<br>}``` |
| **処理内容** | 1. 認証チェック（大家のみ）<br>2. PROP-001関数呼び出し<br>3. 物件ID返却<br>4. 作成ログ記録 |

#### API-013: /api/properties/:id
| 項目 | 内容 |
|------|------|
| **API ID** | API-013 |
| **エンドポイント** | /api/properties/:id |
| **メソッド** | GET |
| **説明** | 物件詳細取得 |
| **入力値** | パスパラメータ: `id: string`<br>クエリパラメータ: `lang?: string` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "id": "property_uuid",<br>    "title": "築浅1K アパート",<br>    "description": "駅徒歩5分の好立地",<br>    "rentAmount": 55000,<br>    "address": {...},<br>    "images": [...],<br>    "amenities": [...],<br>    "nearbyFacilities": [...]<br>  }<br>}``` |
| **処理内容** | 1. 物件ID検証<br>2. PROP-004関数呼び出し<br>3. 周辺施設情報取得<br>4. 閲覧回数更新 |

## 3. 検索関連

### 3.1 関数仕様

#### SEARCH-001: searchProperties
| 項目 | 内容 |
|------|------|
| **ID** | SEARCH-001 |
| **名称** | 物件検索 |
| **説明** | 指定された条件で物件を検索する |
| **入力値** | ```typescript<br>SearchCriteria: {<br>  prefecture?: string,<br>  minRent?: number,<br>  maxRent?: number,<br>  roomType?: string,<br>  keyword?: string,<br>  location?: { lat: number, lng: number, radius: number },<br>  page?: number,<br>  limit?: number<br>}``` |
| **出力値** | ```typescript<br>Promise<SearchResult: {<br>  properties: Property[],<br>  total: number,<br>  page: number,<br>  hasNext: boolean<br>}>``` |
| **処理内容** | 1. 検索条件検証<br>2. SQLクエリ構築<br>3. インデックス活用検索<br>4. 結果ソート・ページング<br>5. キャッシュ保存<br>6. 検索履歴記録 |

### 3.2 APIエンドポイント仕様

#### API-011: /api/properties
| 項目 | 内容 |
|------|------|
| **API ID** | API-011 |
| **エンドポイント** | /api/properties |
| **メソッド** | GET |
| **説明** | 物件検索 |
| **入力値** | クエリパラメータ:<br>`prefecture=群馬県&minRent=30000&maxRent=80000&page=1&limit=20` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "properties": [...],<br>    "pagination": {<br>      "total": 150,<br>      "page": 1,<br>      "limit": 20,<br>      "hasNext": true<br>    }<br>  }<br>}``` |
| **処理内容** | 1. クエリパラメータ解析<br>2. SEARCH-001関数呼び出し<br>3. 結果整形<br>4. キャッシュヘッダー設定 |

## 4. AI Chat関連

### 4.1 関数仕様

#### AI-001: processUserMessage
| 項目 | 内容 |
|------|------|
| **ID** | AI-001 |
| **名称** | ユーザーメッセージ処理 |
| **説明** | ユーザーからのメッセージを解析してAI応答を生成する |
| **入力値** | ```typescript<br>{<br>  message: string,<br>  userId: string,<br>  sessionId: string,<br>  language: string,<br>  context?: ChatContext<br>}``` |
| **出力値** | ```typescript<br>Promise<AIResponse: {<br>  response: string,<br>  intent: string,<br>  confidence: number,<br>  suggestedActions?: Action[]<br>}>``` |
| **処理内容** | 1. メッセージ前処理<br>2. 意図解析実行<br>3. コンテキスト分析<br>4. 適切な応答生成<br>5. 多言語変換<br>6. 履歴保存 |

#### AI-004: searchFAQ
| 項目 | 内容 |
|------|------|
| **ID** | AI-004 |
| **名称** | FAQ検索 |
| **説明** | ユーザーの質問に関連するFAQを検索する |
| **入力値** | `query: string, language: string, category?: string` |
| **出力値** | ```typescript<br>Promise<FAQResult[]> = {<br>  id: string,<br>  question: string,<br>  answer: string,<br>  confidence: number<br>}[]``` |
| **処理内容** | 1. クエリ正規化<br>2. 全文検索実行<br>3. 類似度計算<br>4. 結果ランキング<br>5. 言語フィルタリング |

### 4.2 APIエンドポイント仕様

#### API-036: /api/chat/message
| 項目 | 内容 |
|------|------|
| **API ID** | API-036 |
| **エンドポイント** | /api/chat/message |
| **メソッド** | POST |
| **説明** | チャットメッセージ送信 |
| **入力値** | ```json<br>{<br>  "message": "前橋駅周辺の1K物件を探しています",<br>  "sessionId": "session_uuid",<br>  "language": "ja"<br>}``` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "response": "前橋駅周辺の1K物件を検索いたします。ご予算はいくらぐらいをお考えでしょうか？",<br>    "intent": "property_search",<br>    "suggestedActions": [<br>      {<br>        "type": "search_properties",<br>        "label": "物件を検索",<br>        "params": { "station": "前橋駅", "layout": "1K" }<br>      }<br>    ]<br>  }<br>}``` |
| **処理内容** | 1. ユーザー認証確認<br>2. AI-001関数呼び出し<br>3. 応答データ整形<br>4. リアルタイム通知 |

#### API-039: /api/line/webhook
| 項目 | 内容 |
|------|------|
| **API ID** | API-039 |
| **エンドポイント** | /api/line/webhook |
| **メソッド** | POST |
| **説明** | LINE Bot Webhook処理 |
| **入力値** | LINE Messaging APIの標準形式 |
| **出力値** | HTTP 200 OK |
| **処理内容** | 1. 署名検証<br>2. イベント種別判定<br>3. メッセージ処理<br>4. LINE応答送信<br>5. ユーザー情報同期 |

## 5. 外部連携関連

### 5.1 関数仕様

#### EXT-001: scrapeJimoty
| 項目 | 内容 |
|------|------|
| **ID** | EXT-001 |
| **名称** | ジモティスクレイピング |
| **説明** | ジモティから物件情報を取得する |
| **入力値** | `url: string` |
| **出力値** | `Promise<PropertyData>` |
| **処理内容** | 1. URL検証<br>2. ページ取得<br>3. DOM解析<br>4. データ抽出<br>5. 正規化処理<br>6. 画像ダウンロード |

#### EXT-004: processPDF
| 項目 | 内容 |
|------|------|
| **ID** | EXT-004 |
| **名称** | PDF解析処理 |
| **説明** | マイソクPDFから物件情報を抽出する |
| **入力値** | `pdfBuffer: Buffer` |
| **出力値** | `Promise<PropertyData>` |
| **処理内容** | 1. PDF検証<br>2. OCR処理<br>3. テキスト抽出<br>4. パターンマッチング<br>5. データ構造化<br>6. 信頼度計算 |

### 5.2 APIエンドポイント仕様

#### API-019: /api/properties/external/import
| 項目 | 内容 |
|------|------|
| **API ID** | API-019 |
| **エンドポイント** | /api/properties/external/import |
| **メソッド** | POST |
| **説明** | 外部サイトから物件情報取込 |
| **入力値** | ```json<br>{<br>  "url": "https://jmty.jp/gunma/est-ret/article-xxxxx",<br>  "source": "jimoty"<br>}``` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "propertyId": "imported_uuid",<br>    "status": "imported",<br>    "extractedData": {<br>      "title": "...",<br>      "rent": 50000,<br>      "confidence": 0.95<br>    }<br>  }<br>}``` |
| **処理内容** | 1. URL・ソース検証<br>2. 対応する関数呼び出し<br>3. データ検証・保存<br>4. インポートログ記録 |

#### API-020: /api/properties/pdf/import
| 項目 | 内容 |
|------|------|
| **API ID** | API-020 |
| **エンドポイント** | /api/properties/pdf/import |
| **メソッド** | POST |
| **説明** | PDFから物件情報取込 |
| **入力値** | マルチパート形式でPDFファイル |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "propertyId": "extracted_uuid",<br>    "extractedData": {<br>      "title": "...",<br>      "rent": 60000,<br>      "confidence": 0.88<br>    },<br>    "requiresReview": true<br>  }<br>}``` |
| **処理内容** | 1. ファイル形式検証<br>2. EXT-004関数呼び出し<br>3. 信頼度評価<br>4. レビュー要否判定<br>5. 一時保存処理 |

## 6. 地図・位置情報関連

### 6.1 関数仕様

#### MAP-001: geocodeAddress
| 項目 | 内容 |
|------|------|
| **ID** | MAP-001 |
| **名称** | 住所ジオコーディング |
| **説明** | 住所から緯度経度を取得する |
| **入力値** | `address: string` |
| **出力値** | ```typescript<br>Promise<Coordinates: {<br>  lat: number,<br>  lng: number,<br>  accuracy: string<br>}>``` |
| **処理内容** | 1. 住所正規化<br>2. Google Maps API呼び出し<br>3. 結果検証<br>4. 精度評価<br>5. キャッシュ保存 |

#### MAP-006: searchPlaces
| 項目 | 内容 |
|------|------|
| **ID** | MAP-006 |
| **名称** | 施設検索 |
| **説明** | 指定位置周辺の施設を検索する |
| **入力値** | ```typescript<br>{<br>  query: string,<br>  location: { lat: number, lng: number },<br>  radius: number,<br>  type?: PlaceType<br>}``` |
| **出力値** | ```typescript<br>Promise<Place[]> = {<br>  id: string,<br>  name: string,<br>  type: string,<br>  distance: number,<br>  rating?: number<br>}[]``` |
| **処理内容** | 1. 検索パラメータ検証<br>2. Places API呼び出し<br>3. 距離計算<br>4. 結果フィルタリング<br>5. ソート処理 |

### 6.2 APIエンドポイント仕様

#### API-045: /api/geocode
| 項目 | 内容 |
|------|------|
| **API ID** | API-045 |
| **エンドポイント** | /api/geocode |
| **メソッド** | GET |
| **説明** | 住所から座標取得 |
| **入力値** | クエリパラメータ: `address=群馬県前橋市○○町1-2-3` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "lat": 36.391203,<br>    "lng": 139.060435,<br>    "accuracy": "ROOFTOP",<br>    "formattedAddress": "〒371-0000 群馬県前橋市○○町1丁目2−3"<br>  }<br>}``` |
| **処理内容** | 1. 住所パラメータ検証<br>2. MAP-001関数呼び出し<br>3. 結果キャッシュ確認<br>4. レスポンス整形 |

#### API-048: /api/places/search
| 項目 | 内容 |
|------|------|
| **API ID** | API-048 |
| **エンドポイント** | /api/places/search |
| **メソッド** | GET |
| **説明** | 周辺施設検索 |
| **入力値** | クエリパラメータ:<br>`lat=36.391203&lng=139.060435&radius=1000&type=convenience_store` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "places": [<br>      {<br>        "id": "place_id",<br>        "name": "セブンイレブン前橋○○店",<br>        "type": "convenience_store",<br>        "distance": 150,<br>        "rating": 4.2<br>      }<br>    ],<br>    "total": 5<br>  }<br>}``` |
| **処理内容** | 1. 位置・範囲パラメータ検証<br>2. MAP-006関数呼び出し<br>3. 結果距離順ソート<br>4. ページネーション適用 |

## 7. 通知関連

### 7.1 関数仕様

#### NOTIFY-001: sendEmail
| 項目 | 内容 |
|------|------|
| **ID** | NOTIFY-001 |
| **名称** | メール送信 |
| **説明** | 指定されたアドレスにメールを送信する |
| **入力値** | ```typescript<br>{<br>  to: string,<br>  subject: string,<br>  body: string,<br>  template?: string,<br>  variables?: Record<string, any><br>}``` |
| **出力値** | `Promise<void>` |
| **処理内容** | 1. メールアドレス検証<br>2. テンプレート処理<br>3. SMTP送信<br>4. 送信履歴記録<br>5. エラーハンドリング |

#### NOTIFY-006: getUnreadCount
| 項目 | 内容 |
|------|------|
| **ID** | NOTIFY-006 |
| **名称** | 未読数取得 |
| **説明** | ユーザーの未読通知数を取得する |
| **入力値** | `userId: string` |
| **出力値** | `Promise<number>` |
| **処理内容** | 1. ユーザーID検証<br>2. 未読通知カウント<br>3. キャッシュ確認<br>4. 結果返却 |

### 7.2 APIエンドポイント仕様

#### API-042: /api/notifications
| 項目 | 内容 |
|------|------|
| **API ID** | API-042 |
| **エンドポイント** | /api/notifications |
| **メソッド** | GET |
| **説明** | 通知一覧取得 |
| **入力値** | クエリパラメータ: `page=1&limit=20&unreadOnly=false` |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "notifications": [<br>      {<br>        "id": "notification_uuid",<br>        "title": "新しい問い合わせ",<br>        "message": "○○様から問い合わせが届きました",<br>        "type": "inquiry",<br>        "isRead": false,<br>        "createdAt": "2025-06-19T10:00:00Z"<br>      }<br>    ],<br>    "unreadCount": 3,<br>    "pagination": {...}<br>  }<br>}``` |
| **処理内容** | 1. ユーザー認証確認<br>2. ページネーション処理<br>3. 通知一覧取得<br>4. NOTIFY-006で未読数取得 |

#### API-044: /api/notifications/unread-count
| 項目 | 内容 |
|------|------|
| **API ID** | API-044 |
| **エンドポイント** | /api/notifications/unread-count |
| **メソッド** | GET |
| **説明** | 未読通知数取得 |
| **入力値** | 認証ヘッダーのみ |
| **出力値** | ```json<br>{<br>  "success": true,<br>  "data": {<br>    "unreadCount": 5<br>  }<br>}``` |
| **処理内容** | 1. 認証トークン検証<br>2. NOTIFY-006関数呼び出し<br>3. キャッシュ活用<br>4. リアルタイム更新対応 |

## 8. エラーハンドリング

### 8.1 共通エラーレスポンス形式

```json
{
  "success": false,
  "error": {
    "code": "VALIDATION_ERROR",
    "message": "入力データが不正です",
    "details": {
      "field": "email",
      "reason": "無効なメールアドレス形式です"
    }
  }
}
```

### 8.2 HTTPステータスコード

| コード | 概要 | 使用例 |
|--------|------|--------|
| 200 | 成功 | データ取得成功 |
| 201 | 作成成功 | 新規登録成功 |
| 400 | リクエストエラー | バリデーションエラー |
| 401 | 認証エラー | トークン無効 |
| 403 | 権限エラー | アクセス権限なし |
| 404 | 未存在 | リソースが見つからない |
| 429 | レート制限 | API呼び出し制限超過 |
| 500 | サーバーエラー | 内部処理エラー |