# 機能一覧・処理一覧

## 1. 機能一覧

### 1.1 認証・ユーザー管理機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-001 | 大家会員登録 | 大家のアカウント作成・プロフィール設定 | REQ-001 | 高 |
| FUNC-002 | 入居者会員登録 | 入居希望者のアカウント作成・プロフィール設定 | REQ-012 | 高 |
| FUNC-003 | ログイン・ログアウト | 認証処理・セッション管理 | REQ-001, REQ-012 | 高 |
| FUNC-004 | パスワード管理 | パスワード変更・リセット機能 | REQ-201 | 高 |
| FUNC-005 | 多要素認証 | SMS・メール認証による追加認証 | REQ-201 | 中 |
| FUNC-006 | プロフィール管理 | ユーザー情報の編集・更新 | REQ-001, REQ-012 | 高 |

### 1.2 物件管理機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-007 | 物件手動登録 | フォームからの物件情報入力・登録 | REQ-002 | 高 |
| FUNC-008 | 外部サイト連携登録 | URLから物件情報の自動取得・登録 | REQ-003 | 高 |
| FUNC-009 | PDF自動登録 | マイソクPDFからの自動データ抽出・登録 | REQ-004 | 中 |
| FUNC-010 | 物件画像管理 | 画像のアップロード・編集・削除 | REQ-005 | 高 |
| FUNC-011 | 物件情報編集 | 登録済み物件の情報更新 | REQ-006 | 高 |
| FUNC-012 | 物件公開管理 | 物件の公開/非公開設定 | REQ-007 | 高 |
| FUNC-013 | 物件削除 | 物件情報の削除処理 | REQ-006 | 中 |

### 1.3 検索・表示機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-014 | 物件検索 | 条件指定による物件検索 | REQ-013 | 高 |
| FUNC-015 | 地図検索 | 地図上での物件表示・検索 | REQ-014 | 高 |
| FUNC-016 | 物件詳細表示 | 物件の詳細情報表示 | REQ-015 | 高 |
| FUNC-017 | 物件一覧表示 | 検索結果の一覧表示 | REQ-013 | 高 |
| FUNC-018 | 周辺情報表示 | 物件周辺の施設・交通情報表示 | REQ-019 | 中 |
| FUNC-019 | お気に入り管理 | 物件のお気に入り登録・一覧表示 | REQ-016 | 中 |

### 1.4 コミュニケーション機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-020 | 物件問い合わせ | 入居者から大家への問い合わせ送信 | REQ-017 | 高 |
| FUNC-021 | 問い合わせ管理 | 大家の問い合わせ受信・返信管理 | REQ-008 | 高 |
| FUNC-022 | 入居申込み | オンライン入居申込み手続き | REQ-018 | 中 |
| FUNC-023 | 契約進捗管理 | 入居申込みから契約完了までの進捗管理 | REQ-009 | 中 |
| FUNC-024 | 通知機能 | メール・プッシュ通知の送信 | REQ-020 | 中 |

### 1.5 AI・チャットボット機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-025 | LINE Bot | LINEでのAI相談サービス | REQ-021 | 高 |
| FUNC-026 | 多言語AI応答 | 各言語での自動応答処理 | REQ-022 | 高 |
| FUNC-027 | 物件相談AI | 物件に関する質問への自動応答 | REQ-023 | 高 |
| FUNC-028 | 周辺情報相談AI | 地域情報に関する質問への応答 | REQ-024 | 中 |
| FUNC-029 | 入居手続き案内AI | 入居手続きのガイダンス提供 | REQ-025 | 中 |
| FUNC-030 | FAQ応答AI | よくある質問への自動応答 | REQ-026 | 中 |

### 1.6 多言語・国際化機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-031 | 多言語表示 | 8言語での画面表示切り替え | REQ-011 | 高 |
| FUNC-032 | 自動翻訳 | コンテンツの自動翻訳処理 | REQ-011 | 高 |
| FUNC-033 | 言語設定管理 | ユーザーの言語設定保存・管理 | REQ-011 | 高 |

### 1.7 管理・分析機能

| 機能ID | 機能名 | 概要 | 対応要件 | 優先度 |
|--------|--------|------|----------|--------|
| FUNC-034 | 大家ダッシュボード | 物件・問い合わせ状況の一覧表示 | REQ-010 | 中 |
| FUNC-035 | アクセス分析 | サイトアクセス状況の分析 | REQ-502 | 低 |
| FUNC-036 | 利用統計 | 物件閲覧・問い合わせ統計 | REQ-502 | 低 |

## 2. 処理一覧

### 2.1 認証・セッション処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-001 | ユーザー登録処理 | 新規ユーザーアカウントの作成 | FUNC-001, FUNC-002 | REQ-001, REQ-012 |
| PROC-002 | ログイン認証処理 | ユーザー認証・セッション生成 | FUNC-003 | REQ-001, REQ-012 |
| PROC-003 | ログアウト処理 | セッション破棄・ログアウト | FUNC-003 | REQ-001, REQ-012 |
| PROC-004 | パスワード暗号化処理 | パスワードのハッシュ化 | FUNC-001, FUNC-002, FUNC-004 | REQ-202 |
| PROC-005 | セッション管理処理 | セッションの有効性チェック・更新 | FUNC-003 | REQ-203 |
| PROC-006 | 多要素認証処理 | SMS・メール認証コード送信・検証 | FUNC-005 | REQ-201 |
| PROC-007 | 権限チェック処理 | ユーザー権限の確認・アクセス制御 | 全機能 | REQ-203 |

### 2.2 データ処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-008 | 物件データ登録処理 | 物件情報のデータベース登録 | FUNC-007, FUNC-008, FUNC-009 | REQ-002, REQ-003, REQ-004 |
| PROC-009 | 物件データ更新処理 | 物件情報の更新・編集 | FUNC-011 | REQ-006 |
| PROC-010 | 物件データ削除処理 | 物件情報の削除・論理削除 | FUNC-013 | REQ-006 |
| PROC-011 | 画像アップロード処理 | 画像ファイルのアップロード・保存 | FUNC-010 | REQ-005 |
| PROC-012 | 画像最適化処理 | 画像サイズ・形式の最適化 | FUNC-010 | REQ-101 |
| PROC-013 | データバックアップ処理 | データベースの定期バックアップ | - | REQ-204 |
| PROC-014 | データ暗号化処理 | 個人情報の暗号化・復号化 | 全機能 | REQ-202 |

### 2.3 検索・表示処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-015 | 物件検索処理 | 条件に基づく物件データの検索 | FUNC-014 | REQ-013 |
| PROC-016 | 検索結果ソート処理 | 検索結果の並び替え・ページング | FUNC-017 | REQ-013 |
| PROC-017 | 地図データ取得処理 | Google Maps APIからの地図データ取得 | FUNC-015 | REQ-014 |
| PROC-018 | 周辺施設検索処理 | 物件周辺の施設情報検索 | FUNC-018 | REQ-019 |
| PROC-019 | キャッシュ処理 | 検索結果・画像データのキャッシュ | FUNC-014, FUNC-017 | REQ-101 |

### 2.4 外部連携処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-020 | 外部サイトスクレイピング処理 | ジモティ等からの物件データ取得 | FUNC-008 | REQ-003 |
| PROC-021 | PDF解析処理 | マイソクPDFのOCR・データ抽出 | FUNC-009 | REQ-004 |
| PROC-022 | Google Maps API連携処理 | 地図・住所データの取得・表示 | FUNC-015, FUNC-018 | REQ-014, REQ-019 |
| PROC-023 | 翻訳API連携処理 | 多言語翻訳の実行 | FUNC-032 | REQ-011 |
| PROC-024 | LINE API連携処理 | LINEメッセージの送受信 | FUNC-025 | REQ-021 |
| PROC-025 | データ同期処理 | 外部サイトとの定期データ同期 | FUNC-008 | REQ-003 |

### 2.5 AI・自然言語処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-026 | 自然言語解析処理 | ユーザー質問の意図解析 | FUNC-025, FUNC-026 | REQ-021, REQ-022 |
| PROC-027 | AI応答生成処理 | 質問に対する適切な回答生成 | FUNC-027, FUNC-028, FUNC-029 | REQ-023, REQ-024, REQ-025 |
| PROC-028 | 多言語応答処理 | 各言語での応答文生成 | FUNC-026 | REQ-022 |
| PROC-029 | 学習データ収集処理 | 会話履歴からの学習データ抽出 | FUNC-025 | REQ-021 |
| PROC-030 | FAQ検索処理 | よくある質問からの適切な回答検索 | FUNC-030 | REQ-026 |

### 2.6 通知・コミュニケーション処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-031 | メール送信処理 | 各種通知メールの送信 | FUNC-024 | REQ-020 |
| PROC-032 | プッシュ通知処理 | ブラウザ・アプリへのプッシュ通知 | FUNC-024 | REQ-020 |
| PROC-033 | 問い合わせ処理 | 問い合わせの送信・受信・保存 | FUNC-020, FUNC-021 | REQ-017, REQ-008 |
| PROC-034 | メッセージ履歴管理処理 | 問い合わせ履歴の保存・管理 | FUNC-021 | REQ-008 |
| PROC-035 | 通知設定管理処理 | ユーザーの通知設定管理 | FUNC-024 | REQ-020 |

### 2.7 システム管理処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-036 | ログ出力処理 | アクセス・エラーログの記録 | 全機能 | REQ-502 |
| PROC-037 | 監視処理 | システム稼働状況の監視 | - | REQ-501 |
| PROC-038 | 性能監視処理 | レスポンス時間・負荷の監視 | 全機能 | REQ-101 |
| PROC-039 | セキュリティ監査処理 | 不正アクセス・異常検知 | 全機能 | REQ-201 |
| PROC-040 | データ保持期間管理処理 | データの自動削除・アーカイブ | - | データ保持要件 |

### 2.8 多言語・国際化処理

| 処理ID | 処理名 | 概要 | 関連機能 | 対応要件 |
|--------|--------|------|----------|----------|
| PROC-041 | 言語判定処理 | ユーザーの言語設定・ブラウザ言語判定 | FUNC-031 | REQ-011 |
| PROC-042 | 多言語リソース読込処理 | 言語別テキストリソースの読み込み | FUNC-031 | REQ-011 |
| PROC-043 | 文字エンコード処理 | 多言語文字の適切なエンコード処理 | FUNC-031, FUNC-032 | REQ-011 |
| PROC-044 | 日時・通貨表示処理 | 言語別の日時・通貨フォーマット | FUNC-031 | REQ-011 |

## 3. 処理フロー関連図

### 3.1 主要処理の流れ

| 処理フロー | 関連処理ID | 概要 |
|------------|------------|------|
| ユーザー登録フロー | PROC-001 → PROC-004 → PROC-006 | 登録→暗号化→認証 |
| 物件登録フロー | PROC-008 → PROC-011 → PROC-012 | データ登録→画像UP→最適化 |
| 物件検索フロー | PROC-015 → PROC-016 → PROC-019 | 検索→ソート→キャッシュ |
| 外部連携フロー | PROC-020 → PROC-025 → PROC-008 | 取得→同期→登録 |
| AI相談フロー | PROC-026 → PROC-027 → PROC-028 | 解析→生成→多言語化 |